/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.debuffs;

import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.data.IDebuffs;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.debuffs.IDebuff;
import dev.toma.gunsrpg.common.debuffs.IDebuffType;
import dev.toma.gunsrpg.common.debuffs.RespawnDebuffType;
import dev.toma.gunsrpg.common.init.Skills;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;

public class ReducedHealthDebuff
implements IDebuff {
    private final RespawnDebuffType<?> type;
    private int ticksLeft;

    public ReducedHealthDebuff(RespawnDebuffType<?> type) {
        this.type = type;
        this.ticksLeft = type.getDebuffDuration();
    }

    @Override
    public void tick(PlayerEntity player) {
        ModifiableAttributeInstance attribute = player.func_110148_a(Attributes.field_233818_a_);
        --this.ticksLeft;
        if (this.isActive()) {
            double health = attribute.func_111125_b();
            if (health != 6.0) {
                attribute.func_111128_a(6.0);
                player.func_70606_j(Math.min(player.func_110143_aJ(), 6.0f));
            }
        } else {
            PlayerData.get(player).ifPresent(data -> {
                ISkillProvider provider = data.getSkillProvider();
                double health = provider.hasSkill(Skills.WAR_MACHINE) ? 40.0 : 20.0;
                attribute.func_111128_a(health);
            });
        }
    }

    @Override
    public void heal(int amount, IDebuffs data) {
        throw new UnsupportedOperationException("Attempted to heal unhealable debuff");
    }

    @Override
    public IDebuffType<?> getType() {
        return this.type;
    }

    @Override
    public CompoundNBT toNbt() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("ticksLeft", this.ticksLeft);
        return nbt;
    }

    @Override
    public void fromNbt(CompoundNBT nbt) {
        this.ticksLeft = nbt.func_74762_e("ticksLeft");
    }

    @Override
    public boolean shouldRemove() {
        return !this.isActive();
    }

    @Override
    public boolean isFrozen(IAttributeProvider attributes) {
        return false;
    }

    private boolean isActive() {
        return this.ticksLeft > 0;
    }
}

